<?php
require_once "../config/Conexion.php"; // Tu archivo de conexión
require("generar.php"); // Generador para nombres únicos

class Imagenes
{
    private $conexion;
    private $Generar;

    // Implementamos nuestro constructor
    public function __construct()
    {
        // Inicializamos la conexión y el generador
        //$this->conexion = Conexion::conectar(); // Asegúrate de tener una conexión correcta en este método
        $this->Generar = new Generar(); // Inicializamos el generador
    }

    // Función para obtener extensión del archivo
    function getFileExtension(string $filename) : string {
        //$filename = 1.jpg            |   ["1", "jpg"]       | return ".jpg"
        $name = explode(".", $filename);
        return ".".array_pop($name);
    }

    public function insertar($nombre, $telef, $id_barrio,$detalle, $lat, $long, $dni, $id_tematica)
    {
        // Establece la zona horaria a la de Perú
        date_default_timezone_set('America/Lima');

        // Obtiene la fecha y hora actual en formato "Y-m-d H:i:s"
        $fecha_hora = date("Y-m-d H:i:s");
        $sql="INSERT INTO reporte (nombre_reportador, telefono_reportador, id_barrio, detalle_reporte, lat_reporte, long_reporte, fecha_reporte, dni_reportador, id_tematica) VALUES
                                    ('$nombre', '$telef', '$id_barrio','$detalle', '$lat','$long', '$fecha_hora', '$dni', '$id_tematica');";
        $sql2="INSERT INTO notificacion (id_barrio, fecha_notificacion) VALUES
                                    ('$id_barrio', '$fecha_hora');";

        ejecutarConsulta($sql);
        $id_reporte_new = retornarUltimoID();

        ejecutarConsulta($sql2);
        
        return $id_reporte_new;
    }
	


public function subirImagenes($files, $fotosASubir, $id_reporte)
{
    // Filtro para asegurarnos que los archivos tienen nombre
    $files = array_filter($files, function($item) {
        return $item["name"][0] != "";
    });

    // Procesar todos los inputs de archivos dinámicos
    foreach ($files as $InputFile) {
        // Aquí recorremos cada archivo individualmente
        $length = count($InputFile["name"]);
        for ($i = 0; $i < $length; $i++) {
            $tmp_name = $InputFile["tmp_name"][$i];
            $name = $InputFile["name"][$i];
            $extension = $this->getFileExtension($name);
            $newName = $this->Generar->GenerarP(10) . $extension;
            $path = "../public/images/reportes/$newName";

            // Verificar si el archivo es parte de las fotos a subir (comprobación en POST)
            if (in_array($name, $fotosASubir)) {
                // Insertar imagen en la base de datos
                if (!move_uploaded_file($tmp_name, $path)) {
                    return 'error al mover el archivo';
                }else{
                    $sql = "INSERT INTO imagenes (image, id_reporte) VALUES ('$newName', '$id_reporte')";
                    ejecutarConsulta($sql);
                }
            }else {
                return 'no hay'; // Si hay un error al insertar en la BD
            }
        }
    }
    return true;
}
    public function select()
	{
		$sql="SELECT id_barrio, nombre_barrio FROM barrios;";
		return ejecutarConsulta($sql);		
	}

    public function selectTematica()
	{
		$sql="SELECT * FROM tematica;";
		return ejecutarConsulta($sql);		
	}

    public function selectDept()
	{
		$sql="SELECT * FROM departamento;";
		return ejecutarConsulta($sql);		
	}

    public function selectProv($id_departamento)
	{
		$sql="SELECT id_provincia, nombre_provincia 
            FROM provincia 
            WHERE id_departamento = '$id_departamento';
            ";
		return ejecutarConsulta($sql);	
        
	}
    public function selectDistr($id_departamento, $id_provincia)
	{
		$sql="SELECT id_distrito, nombre_distrito 
            FROM distrito 
            WHERE id_provincia='$id_provincia';
            ";
		return ejecutarConsulta($sql);	
        
	}
    public function selectDistrSin()
	{
		$sql="SELECT DISTINCT b.id_distrito, d.nombre_distrito 
            FROM barrio b
            join distrito d on d.id_distrito = b.id_distrito
            WHERE d.estado_distrito = TRUE;
            ";
		return ejecutarConsulta($sql);	
        
	}
    public function selectBarrio($id_departamento, $id_provincia, $id_distrito)
	{
		$sql="SELECT id_barrio, nombre_barrio
        FROM barrio
        WHERE id_distrito =$id_distrito ;";
		return ejecutarConsulta($sql);	
        
	}

    public function selectProvCompl()
	{
		$sql="SELECT DISTINCT p.id_provincia, p.nombre_provincia 
            FROM localidad l 
            JOIN provincia p ON l.id_provincia = p.id_provincia 
            ;
            ";
		return ejecutarConsulta($sql);	
        
	}
    
}
?>
